CREATE PROCEDURE [LIMPA_TRANSACTION_LOG] @DBName varchar(50)

AS

DECLARE

 @TipLimTLog        VARCHAR(4),

 @DirBkpTLog        VARCHAR(100),

 @NomJobTLog        VARCHAR(50),

 @arquivo VARCHAR(100),

 @RunStatus int

 

BEGIN

 SET NOCOUNT ON;

 SELECT @TipLimTLog = TipLimTLog FROM TBPARMANDB

 SELECT @DirBkpTLog = DirBkpTLog FROM TBPARMANDB

 SELECT @NomJobTLog = NomJobTLog FROM TBPARMANDB

 SET @DBName = (SELECT REPLACE(REPLACE(@DBName,'[',''),']',''))

 

 IF @TipLimTLog = 'PROC' -- gera backup do transaction log no diretrio especificado com nome concatenado

 BEGIN

         SET @arquivo = @DirBkpTLog + '\' + @DBName + '_' + replace(replace(replace(convert(varchar(50), getdate(), 120),'-',''),':',''),' ','') + '.trn'

         BACKUP LOG @DBName TO DISK=@arquivo

 END

 ELSE                                        -- executa job destinado para backup do transaction log, caso o status = 1 (rodando) a procedure aguarda a concluso

 BEGIN

         -- verifica o status do job informado

         EXECUTE sp_MonitorProcessingJob @status = @RunStatus OUTPUT;

         -- enquando o job estiver executando, ele aguarda 5 segundos e verificad novamente o status

         WHILE @RunStatus = 1

         BEGIN

                 WAITFOR DELAY '00:00:05'

                 EXECUTE sp_MonitorProcessingJob @status = @RunStatus OUTPUT;

         END

         -- executa o job informado

         EXEC msdb.dbo.sp_start_job @NomJobTLog;

         -- aguarda o job encerrar para voltar para a procedure de limpeza

         EXECUTE sp_MonitorProcessingJob @status = @RunStatus OUTPUT;

         WHILE @RunStatus = 1

         BEGIN

                 WAITFOR DELAY '00:00:05'

                 EXECUTE sp_MonitorProcessingJob @status = @RunStatus OUTPUT;

         END

 END

END